#!/bin/sh
# INSTALLED VIA config-package dxld-configs

set -xe

cmd=$1; shift
netns=$1; shift

case $cmd in
	up)
		ip netns add pub ||:
		ip -netns "$netns" link set dev lo up

		ip link del veth-pub ||:
		ip link add name veth-pub type veth \
		  peer name eth0 address 02:5d:26:75:68:4a netns "$netns"
		ip link set dev veth-pub master br0
		#bridge vlan add dev veth-pub vid 4 tagged

		ip -netns "$netns" token set dev eth0 ::1a57
		ip -netns "$netns" token

		ip link set dev veth-pub up
		ip -netns "$netns" link set dev eth0 up

		# wait for defroute | bridge STP delay...
		while ! ip -netns "$netns" route get ::; do sleep 1; done
		;;

	down)
		ip -netns "$netns" link del eth0
		;;
esac

ip netns exec "$netns" wg-quick "$cmd" keke-pub4
