#!/bin/sh
set -x
cmd=$1; shift
netns=$1; shift

case $cmd in
	up)
		ip link add name veth-pub type veth \
		  peer name eth0 address 02:5d:26:75:68:4a netns "$netns"
		ip link set dev veth-pub master br0
		bridge vlan add dev veth-pub vid 4 tagged

		ip -netns "$netns" link add link eth0 name eth0.4 \
		   address 26:c4:07:00:00:02 type vlan id 4

		# Don't intall default route from RA or else wg-dxld
		# default route will conflict
		ip netns exec "$netns" sysctl net.ipv6.conf.eth0.accept_ra_defrtr=0

		ip -netns "$netns" addr add dev eth0 10.10.10.148/24

		ip link set dev veth-pub up
		ip -netns "$netns" link set dev eth0 up
		ip -netns "$netns" link set dev eth0.4 up
		;;
	down)
		ip -netns "$netns" link del eth0.4
		ip -netns "$netns" link del eth0
		;;
esac

ip netns exec "$netns" wg-quick "$cmd" dxldv6
