#!/bin/sh

SSH="ssh -o ControlMaster=auto -o ControlPersist=30 -o ControlPath=/run/user/%i/ssh-deploy-dxld-configs-%C"

ver=$(dpkg-parsechangelog --show-field Version)

grep -v '^[[:space:]]*;\|#' deploy.list | while read -r ssh_host; do
	echo Deploying to $ssh_host
	dcmd rsync -e "$SSH" "$@" --progress -t \
	     ../dxld-configs_"$ver"_*.changes $ssh_host:local-debs/
	$SSH $ssh_host -n 'cd local-debs && apt-ftparchive packages . > Packages'
	$SSH $ssh_host -O exit
	printf '\n\n\n'
done
